/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.base.service;

import itx.erp.base.model.Activity;
import itx.erp.base.model.Note;
import itx.erp.base.service.ErpServiceBase;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import jtbcore.exception.JTBException;

public class NoteService
extends ErpServiceBase {
    final String[] noteLogFields = new String[]{"important", "shortNote", "longNote"};

    public Note readNote(Integer noteId) throws SQLException, JTBException {
        Note n = (Note)this.queryToObject(Note.class, "select * from base__note where note_id = ?", noteId);
        return n;
    }

    public List<Note> readByRef(String refObject, Integer refId) throws SQLException, JTBException {
        List notes = this.queryToList(Note.class, "select note_id, short_note, important, edited, created from base__note where ref_object = ? and ref_id = ? order by sort, note_id", refObject, refId);
        return notes;
    }

    public Integer save(Note n, Integer loggedIn_userId) throws IOException, SQLException, JTBException {
        Note old_note = null;
        if (n.getNoteId() != null) {
            old_note = this.readNote(n.getNoteId());
        }
        Integer i = this.connection.save("base__note", "note_id", n.getBaseStringMap());
        n.setNoteId(i);
        Activity a = new Activity();
        a.setRefObject(n.getRefObject());
        a.setRefId(n.getRefId());
        a.setSubRefObject(Note.class.getName());
        a.setRefId(n.getNoteId());
        if (loggedIn_userId != null) {
            a.setUserId(loggedIn_userId);
        }
        if (old_note != null) {
            a.setCode("note-updated");
            a.setShortDescription("Note updated");
            a.logChange(old_note, n, this.noteLogFields);
        } else {
            a.setCode("note-new");
            a.setShortDescription("Note created");
            a.logNew(n, this.noteLogFields);
        }
        this.saveActivity(a);
        return i;
    }

    public void deleteNote(Integer noteId, Integer loggedIn_userId) throws IOException, SQLException, JTBException {
        Note note = this.readNote(noteId);
        this.connection.query("delete from base__note where note_id = ?", noteId);
        Activity a = new Activity();
        a.setRefObject(note.getRefObject());
        a.setRefId(note.getRefId());
        a.setSubRefObject(Note.class.getName());
        a.setRefId(note.getNoteId());
        if (loggedIn_userId != null) {
            a.setUserId(loggedIn_userId);
        }
        a.setCode("note-deleted");
        a.setShortDescription("Note deleted: " + note.getShortNote());
        a.logDelete(note, this.noteLogFields);
        this.saveActivity(a);
    }

    public void updateNoteSort(List<Integer> ids) throws SQLException {
        int x = 0;
        while (x < ids.size()) {
            if (ids.get(x) != null) {
                this.connection.query("update base__note set sort = ? where note_id = ?", x, ids.get(x));
            }
            ++x;
        }
    }
}

